<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Plain Jane Text</title>
    <style type="text/css">
      /* Based on The MailChimp Reset INLINE: Yes. */
      /* Client-specific Styles */
      #outlook a {
        padding: 0;
      }

      /* Force Outlook to provide a "view in browser" menu link. */
      body {
        width: 100% !important;
        margin: 0;
        padding: 0;
        -webkit-text-size-adjust: 100%;
        -ms-text-size-adjust: 100%;
      }

      /* Prevent Webkit and Windows Mobile platforms from changing default font sizes.*/
      .ExternalClass {
        width: 100%;
      }

      /* Force Hotmail to display emails at full width */
      .ExternalClass,
      .ExternalClass p,
      .ExternalClass span,
      .ExternalClass font,
      .ExternalClass td,
      .ExternalClass div {
        line-height: 100%;
      }

      /* Forces Hotmail to display normal line spacing.  More on that: http://www.emailonacid.com/forum/viewthread/43/ */
      #backgroundTable {
        margin: 0;
        padding: 0;
        width: 100% !important;
        line-height: 100% !important;
      }
      /* End reset */
      /* Some sensible defaults for images
          Bring inline: Yes. */

      img {
        outline: none;
        text-decoration: none;
        -ms-interpolation-mode: bicubic;
      }

      a img {
        border: none;
      }

      .image_fix {
        display: block;
      }

      /* Yahoo paragraph fix
          Bring inline: Yes. */
      p {
        margin: 1em 0;
      }

      /* Hotmail header color reset
          Bring inline: Yes. */
      h1, h2, h3, h4, h5, h6 {
        color: black !important;
      }

      h1 a, h2 a, h3 a, h4 a, h5 a, h6 a {
        color: blue !important;
      }

      h1 a:active, h2 a:active, h3 a:active, h4 a:active, h5 a:active, h6 a:active {
        color: red !important;
        /* Preferably not the same color as the normal header link color.  There is limited support for psuedo classes in email clients, this was added just for good measure. */
      }

      h1 a:visited, h2 a:visited, h3 a:visited, h4 a:visited, h5 a:visited, h6 a:visited {
        color: #000;
        color: purple !important;
        /* Preferably not the same color as the normal header link color. There is limited support for psuedo classes in email clients, this was added just for good measure. */
      }

      /* Outlook 07, 10 Padding issue fix
          Bring inline: No.*/
      table td {
        border-collapse: collapse;
      }

      /* Remove spacing around Outlook 07, 10 tables
          Bring inline: Yes */
      table {
        border-collapse: collapse;
        mso-table-lspace: 0pt;
        mso-table-rspace: 0pt;
      }


      /* Global */
      * {
        margin: 0;
        padding: 0;
      }

      body {
        -webkit-text-size-adjust: 100%;
        -ms-text-size-adjust: 100%;
        width: 100%!important;
        height: 100%;
        font-family: Cambria, Utopia, "Liberation Serif", Times, "Times New Roman", serif;
        font-weight: 400;
        font-size: 100%;
        line-height: 1.6;
      }

      /* Styling your links has become much simpler with the new Yahoo.  In fact, it falls in line with the main credo of styling in email and make sure to bring your styles inline.  Your link colors will be uniform across clients when brought inline.
          Bring inline: Yes. */
      a {
        color: #348eda;
      }

      h1, h2, h3, h4, h5,
      p, ul, ol {
        /* This fixes Gmail's terrible text rendering  */
        font-family: Cambria, Utopia, "Liberation Serif",Times, "Times New Roman", serif;
        font-weight: 400;
      }

      h1, h2, h3, h4, h5 {
        margin: 20px 0 10px;
        color: #000;
        line-height: 1.2;
      }

      h1 { font-size: 32px; }
      h2 { font-size: 26px; }
      h3 { font-size: 22px; }
      h4 { font-size: 18px; }
      h5 { font-size: 16px; }

      p, ul, ol {
        margin-bottom: 10px;
        font-weight: normal;
        font-size: 16px;
        line-height: 1.4;
      }

      ul li,
      ol li {
        margin-left: 5px;
        list-style-position: inside;
      }

      /* Body */
      table.body-wrap {
        width: 100%;
        padding: 30px;
      }


      /* Footer */
      table.footer-wrap {
        width: 100%;
        clear: both!important;
      }

      .footer-wrap .container p {
        font-size: 12px;
        color: #666;
      }

      table.footer-wrap a {
        color: #999;
      }


      /* Give it some responsive love */
      .container {
        display: block!important;
        max-width: 600px!important;
        margin: 0 auto!important; /* makes it centered */
        clear: both!important;
      }

      /* Set the padding on the td rather than the div for Outlook compatibility */
      .body-wrap .container {
        padding: 30px;
      }

      /* This should also be a block element, so that it will fill 100% of the .container */
      .content {
        max-width: 600px;
        margin: 0 auto;
        display: block;
      }

      /* Let's make sure tables in the content area are 100% wide */
      .content table {
        width: 100%;
      }
    </style>
    <!--[if gte mso 9]>
      <style>
        /* Target Outlook 2007 and 2010 */
      </style>
    <![endif]-->
  </head>

  <body>

    <table id="backgroundTable" cellpadding="0" cellspacing="0" border="0">
      <tr>
        <td>

          <!-- body -->
          <table class="body-wrap">
            <tr>
              <td></td>
              <td class="container" bgcolor="#FFFFFF" valign="top">

                <!-- content -->
                <div class="content">
                <table>
                  <tr>
                    <td>
                      <h1>The Cyber House Rules</h1>
                      <p>Bacon ipsum dolor amet labore in exercitation prosciutto, consequat chuck excepteur short ribs sausage ut occaecat frankfurter shankle. Drumstick tongue nostrud qui ham hock kielbasa. Laborum meatloaf ham hock magna ex, bacon fatback deserunt adipisicing est. Cillum fugiat salami consectetur dolore, corned beef in et t-bone. Pork loin t-bone nisi pork, culpa hamburger andouille ut pastrami lorem nulla. Strip steak corned beef meatloaf, fugiat tenderloin eu id enim in pork belly nulla sunt ipsum.</p>

                      <h2>Lrrreconcilable Ndndifferences</h2>
                      <p>Nulla elit nostrud duis. Flank porchetta cow pastrami dolore quis salami qui tenderloin ham ea. Irure short ribs hamburger tail ribeye kielbasa. Hamburger id veniam filet mignon sed fatback anim ham hock cupidatat bacon tri-tip ham. Ut laborum ribeye, bresaola officia boudin salami biltong ullamco t-bone alcatra in sausage. Flank laboris ball tip ground round turkey turducken, excepteur drumstick in elit. Esse pastrami short ribs tempor proident.</p>

                      <ul>
                        <li>Ball tip alcatra elit shankle, ground round consectetur beef ribs hamburger</li>
                        <li>Ut sirloin incididunt, beef ribs tempor meatloaf reprehenderit brisket pork ad in elit</li>
                        <li>Magna lorem proident, irure id et ullamco cupim chuck</li>
                      </ul>

                      <h3>Bendin' in the Wind</h3>
                      <p>Landjaeger dolore lorem, shankle salami bacon exercitation est. Eu meatball enim do bresaola excepteur. In boudin tail bacon in hamburger beef ribs culpa consectetur pork short ribs magna chuck. Short loin do occaecat elit kevin pork loin, duis pancetta cupidatat est mollit voluptate bacon flank. Alcatra chicken jowl, biltong porchetta tri-tip sausage officia elit sirloin pork chop quis turkey dolore aliqua.</p>

                      <h4>The Late Philip J. Fry</h4>
                      <p>Swine cupidatat ullamco eu dolore, ea deserunt ball tip lorem bacon shankle. Cow andouille beef ribs beef cillum ham tenderloin alcatra. Do spare ribs aliquip in prosciutto, sunt filet mignon dolore tail ribeye aliqua salami id doner. Et aliqua ad ham exercitation. Prosciutto sirloin kielbasa, short loin adipisicing laboris bresaola pork chop picanha.</p>

                      <ol>
                        <li>Pig alcatra do incididunt ad tail</li>
                        <li>Ball tip beef aliquip tongue</li>
                        <li>Ut aliquip beef officia, laboris culpa pork chop eu esse jowl est</li>
                        <li>Mollit cupim cillum deserunt, eu corned beef aute bresaola pig laboris dolor beef ribs brisket</li>
                      </ol>

                      <h5>Love and Rocket</h5>
                      <p>In sunt do esse pariatur enim brisket. Tri-tip dolor salami beef ribs, pork loin officia picanha anim meatball capicola enim laborum ad incididunt sirloin. Pork tenderloin prosciutto ribeye et. Mollit sirloin ham ut. Tail pig ad pork loin dolor excepteur. Landjaeger veniam biltong nulla, est jerky ea. Fatback esse magna do incididunt in quis, ex ut frankfurter meatloaf nisi cupidatat doner bresaola.</p>

                    </td>
                  </tr>
                </table>
                </div>
                <!-- /content -->

              </td>
              <td></td>
            </tr>
          </table>
          <!-- /body -->

          <!-- footer -->
          <table class="footer-wrap" cellpadding="0" cellspacing="0" border="0" align="center" >
            <tr>
              <td></td>
              <td class="container">

                <!-- content -->
                <div class="content">
                  <table>
                    <tr>
                      <td align="center" valign="top">
                        <p>Don't like these emails? <a href="#"><unsubscribe>Unsubscribe</unsubscribe></a>.</p>
                      </td>
                    </tr>
                  </table>
                </div>
                <!-- /content -->

              </td>
              <td></td>
            </tr>
          </table>
          <!-- /footer -->

        </td>
      </tr>
    </table>
  </body>
</html>
